/*
 * Decompiled with CFR 0.152.
 */
package com.pty4j.unix;

import com.pty4j.PtyProcess;
import com.pty4j.WinSize;
import com.pty4j.unix.Pty;
import com.pty4j.unix.UnixPtyException;
import com.pty4j.util.PtyUtil;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.time.Duration;
import kotlin.time.DurationUnit;
import kotlin.time.TimeSource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cBg\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0012\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0004\u0012\u0006\u0010\b\u001a\u00020\t\u0012\b\u0010\n\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\b\u0010\u000f\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0004\b\u0012\u0010\u0013J \u0010\u0018\u001a\u00020\u00192\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u001bH\u0002R\u0011\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006\u001d"}, d2={"Lcom/pty4j/unix/ProcessBuilderUnixLauncher;", "", "command", "", "", "environmentMap", "", "workingDirectory", "pty", "Lcom/pty4j/unix/Pty;", "errPty", "consoleMode", "", "initialColumns", "", "initialRows", "ptyProcess", "Lcom/pty4j/PtyProcess;", "<init>", "(Ljava/util/List;Ljava/util/Map;Ljava/lang/String;Lcom/pty4j/unix/Pty;Lcom/pty4j/unix/Pty;ZLjava/lang/Integer;Ljava/lang/Integer;Lcom/pty4j/PtyProcess;)V", "process", "Ljava/lang/Process;", "getProcess", "()Ljava/lang/Process;", "initTermSize", "", "initSize", "Lcom/pty4j/WinSize;", "Companion", "pty4j"})
public final class ProcessBuilderUnixLauncher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Process process;
    @NotNull
    private static final Logger LOG;

    public ProcessBuilderUnixLauncher(@NotNull List<String> command, @NotNull Map<String, String> environmentMap, @NotNull String workingDirectory, @NotNull Pty pty, @Nullable Pty errPty, boolean consoleMode, @Nullable Integer initialColumns, @Nullable Integer initialRows, @NotNull PtyProcess ptyProcess) throws Exception {
        Intrinsics.checkNotNullParameter(command, "command");
        Intrinsics.checkNotNullParameter(environmentMap, "environmentMap");
        Intrinsics.checkNotNullParameter(workingDirectory, "workingDirectory");
        Intrinsics.checkNotNullParameter(pty, "pty");
        Intrinsics.checkNotNullParameter(ptyProcess, "ptyProcess");
        File file = PtyUtil.resolveNativeFile("pty4j-unix-spawn-helper");
        Intrinsics.checkNotNullExpressionValue(file, "resolveNativeFile(...)");
        File spawnHelper = file;
        ProcessBuilder builder = new ProcessBuilder(new String[0]);
        String[] stringArray = new String[7];
        stringArray[0] = spawnHelper.getAbsolutePath();
        stringArray[1] = workingDirectory;
        stringArray[2] = String.valueOf(consoleMode ? 1 : 0);
        stringArray[3] = pty.getSlaveName();
        stringArray[4] = String.valueOf(pty.getMasterFD());
        Pty pty2 = errPty;
        String string = pty2 != null ? pty2.getSlaveName() : null;
        if (string == null) {
            string = "";
        }
        stringArray[5] = string;
        Pty pty3 = errPty;
        stringArray[6] = String.valueOf(pty3 != null ? pty3.getMasterFD() : -1);
        builder.command(CollectionsKt.plus((Collection)CollectionsKt.listOf(stringArray), (Iterable)command));
        Map<String, String> environment = builder.environment();
        environment.clear();
        environment.putAll(environmentMap);
        builder.directory(new File(workingDirectory));
        builder.redirectInput(ProcessBuilder.Redirect.from(new File("/dev/null")));
        builder.redirectOutput(ProcessBuilder.Redirect.DISCARD);
        ProcessBuilder processBuilder = errPty == null ? builder.redirectErrorStream(true) : builder.redirectError(ProcessBuilder.Redirect.DISCARD);
        Process process = builder.start();
        Intrinsics.checkNotNullExpressionValue(process, "start(...)");
        this.process = process;
        Integer n = initialColumns;
        Integer n2 = initialRows;
        this.initTermSize(pty, ptyProcess, new WinSize(n != null ? n : 80, n2 != null ? n2 : 25));
    }

    @NotNull
    public final Process getProcess() {
        return this.process;
    }

    private final void initTermSize(Pty pty, PtyProcess ptyProcess, WinSize initSize) {
        long start = TimeSource.Monotonic.INSTANCE.markNow-z9LOYto();
        UnixPtyException lastException = null;
        int performedAttempts = 0;
        while (performedAttempts < 1000) {
            try {
                ++performedAttempts;
                pty.setWindowSize(initSize, ptyProcess);
                lastException = null;
                break;
            }
            catch (UnixPtyException e) {
                lastException = e;
                if (e.getErrno() != 25) break;
                Thread.sleep(2L);
            }
        }
        if (lastException != null) {
            LOG.warn("Failed to set initial terminal size, attempts: " + performedAttempts, lastException);
        } else if (LOG.isDebugEnabled()) {
            long elapsed = TimeSource.Monotonic.ValueTimeMark.elapsedNow-UwyO8pc(start);
            LOG.debug("Terminal initial size set to (" + initSize + ") in " + Duration.toString-impl$default(elapsed, DurationUnit.MILLISECONDS, 0, 2, null) + ", attempt: " + performedAttempts);
        }
    }

    static {
        Logger logger = LoggerFactory.getLogger(ProcessBuilderUnixLauncher.class);
        Intrinsics.checkNotNullExpressionValue(logger, "getLogger(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/pty4j/unix/ProcessBuilderUnixLauncher$Companion;", "", "<init>", "()V", "LOG", "Lorg/slf4j/Logger;", "pty4j"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

