/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.ui.debug;

import com.jediterm.terminal.util.CharUtils;
import com.jediterm.ui.debug.ControlSequenceSettings;
import com.jediterm.ui.debug.TeseqVisualizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\u0010\u0019\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\f\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fJ\u0010\u0010\r\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u0005H\u0002J \u0010\u000f\u001a\u00020\u00052\u0006\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0005H\u0002J2\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00050\tH\u0002\u00a8\u0006\u0016"}, d2={"Lcom/jediterm/ui/debug/ControlSequenceVisualizer;", "", "<init>", "()V", "getVisualizedString", "", "logStart", "", "arrayChunks", "", "", "settings", "Lcom/jediterm/ui/debug/ControlSequenceSettings;", "toHumanReadableSpace", "escSeq", "makeCharHumanReadable", "ch", "", "presentable", "withChunkId", "chunks", "originalChunks", "JediTerm"})
@SourceDebugExtension(value={"SMAP\nControlSequenceVisualizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ControlSequenceVisualizer.kt\ncom/jediterm/ui/debug/ControlSequenceVisualizer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,64:1\n1563#2:65\n1634#2,3:66\n1563#2:69\n1634#2,3:70\n*S KotlinDebug\n*F\n+ 1 ControlSequenceVisualizer.kt\ncom/jediterm/ui/debug/ControlSequenceVisualizer\n*L\n11#1:65\n11#1:66,3\n17#1:69\n17#1:70,3\n*E\n"})
public final class ControlSequenceVisualizer {
    @NotNull
    public static final ControlSequenceVisualizer INSTANCE = new ControlSequenceVisualizer();

    private ControlSequenceVisualizer() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final String getVisualizedString(int logStart, @NotNull List<char[]> arrayChunks, @NotNull ControlSequenceSettings settings) {
        List originalChunks;
        Collection collection;
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(arrayChunks, "arrayChunks");
        Intrinsics.checkNotNullParameter(settings, "settings");
        Iterable $this$map$iv = arrayChunks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            char[] cArray = (char[])item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new String((char[])it));
        }
        List chunks = originalChunks = (List)destination$iv$iv;
        if (settings.getUseTeseq()) {
            chunks = new TeseqVisualizer().apply(chunks);
        }
        if (settings.getShowInvisibleCharacters()) {
            void $this$mapTo$iv$iv2;
            Iterable $this$map$iv2 = chunks;
            boolean $i$f$map2 = false;
            destination$iv$iv = $this$map$iv2;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv2, 10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                String bl = (String)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl2 = false;
                collection.add(CharUtils.toHumanReadableText(INSTANCE.toHumanReadableSpace((String)it)));
            }
            chunks = (List)destination$iv$iv2;
        }
        if (settings.getShowChunkId()) {
            chunks = this.withChunkId(logStart, chunks, originalChunks);
        }
        return CollectionsKt.joinToString$default(chunks, "", null, null, 0, null, null, 62, null);
    }

    private final String toHumanReadableSpace(String escSeq) {
        return this.makeCharHumanReadable(escSeq, ' ', "S");
    }

    private final String makeCharHumanReadable(String escSeq, char ch, String presentable) {
        Pattern pattern = Pattern.compile(Pattern.quote(String.valueOf(ch)) + "+");
        Matcher matcher = pattern.matcher(escSeq);
        StringBuilder builder = new StringBuilder();
        int lastInd = 0;
        while (matcher.find()) {
            String spaces;
            int startInd = matcher.start();
            int endInd = matcher.end();
            Intrinsics.checkNotNullExpressionValue(escSeq.substring(startInd, endInd), "substring(...)");
            if (!Intrinsics.areEqual(spaces, StringsKt.repeat(String.valueOf(ch), endInd - startInd))) {
                throw new IllegalStateException("Not spaces");
            }
            String string = escSeq.substring(lastInd, startInd);
            Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
            builder.append(string);
            StringBuilder stringBuilder = spaces.length() > 1 ? builder.append("<" + presentable + ":").append(spaces.length()).append(">") : builder.append("<" + presentable + ">");
            lastInd = endInd;
        }
        String string = escSeq.substring(lastInd, escSeq.length());
        Intrinsics.checkNotNullExpressionValue(string, "substring(...)");
        builder.append(string);
        String string2 = builder.toString();
        Intrinsics.checkNotNullExpressionValue(string2, "toString(...)");
        return string2;
    }

    private final List<String> withChunkId(int logStart, List<String> chunks, List<String> originalChunks) {
        if (!(chunks.size() == originalChunks.size())) {
            throw new IllegalStateException("Check failed.");
        }
        ArrayList<Object> result = new ArrayList<Object>();
        Iterator iterator2 = ((Iterable)chunks).iterator();
        int n = 0;
        while (iterator2.hasNext()) {
            int id = n++;
            String chunk = (String)iterator2.next();
            String label = "--- #" + (id + 1 + logStart) + " (received " + originalChunks.get(id).length() + " chars) ---\n";
            result.add(id == 0 ? label : "\n" + label);
            result.add(chunk);
        }
        return result;
    }
}

