/*
 * Decompiled with CFR 0.152.
 */
package com.jediterm.terminal.emulator;

import com.jediterm.terminal.TerminalDataStream;
import com.jediterm.terminal.util.CharUtils;
import java.io.IOException;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\b\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0001\u0015B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\r\u001a\u00020\u000eJ\u0016\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u000eJ\u001a\u0010\u0011\u001a\u00020\u000e2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0010\u001a\u00020\u000eH\u0002J\u0014\u0010\u0013\u001a\u00020\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\tJ\b\u0010\u0014\u001a\u00020\u0007H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0016"}, d2={"Lcom/jediterm/terminal/emulator/SystemCommandSequence;", "", "stream", "Lcom/jediterm/terminal/TerminalDataStream;", "<init>", "(Lcom/jediterm/terminal/TerminalDataStream;)V", "text", "", "args", "", "getArgs", "()Ljava/util/List;", "getStringAt", "index", "", "getIntAt", "defaultValue", "parseInt", "value", "format", "toString", "Companion", "core"})
public final class SystemCommandSequence {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String text;
    @NotNull
    private final List<String> args;
    private static final char ST = '\u009c';
    private static final char ARG_SEPARATOR = ';';
    public static final char OSC = '\u009d';

    public SystemCommandSequence(@NotNull TerminalDataStream stream) throws IOException {
        Intrinsics.checkNotNullParameter(stream, "stream");
        StringBuilder textBuf = new StringBuilder();
        do {
            textBuf.append(stream.getChar());
        } while (!SystemCommandSequence.Companion.isTerminated(textBuf));
        String string = textBuf.toString();
        Intrinsics.checkNotNullExpressionValue(string, "toString(...)");
        this.text = string;
        String body = StringsKt.dropLast(this.text, SystemCommandSequence.Companion.terminatorLength(this.text));
        char[] cArray = new char[]{';'};
        List list = List.copyOf(StringsKt.split$default((CharSequence)body, cArray, false, 0, 6, null));
        Intrinsics.checkNotNullExpressionValue(list, "copyOf(...)");
        this.args = list;
    }

    @NotNull
    public final List<String> getArgs() {
        return this.args;
    }

    @Nullable
    public final String getStringAt(int index) {
        return CollectionsKt.getOrNull(this.args, index);
    }

    public final int getIntAt(int index, int defaultValue) {
        return this.parseInt(CollectionsKt.getOrNull(this.args, index), defaultValue);
    }

    private final int parseInt(String value, int defaultValue) {
        Object object = value;
        return object != null && (object = StringsKt.toIntOrNull((String)object)) != null ? (Integer)object : defaultValue;
    }

    @NotNull
    public final String format(@NotNull List<String> args) {
        Intrinsics.checkNotNullParameter(args, "args");
        char c = '\u001b';
        String string = "]";
        return c + string + CollectionsKt.joinToString$default(args, ";", null, null, 0, null, null, 62, null) + StringsKt.takeLast(this.text, SystemCommandSequence.Companion.terminatorLength(this.text));
    }

    @NotNull
    public String toString() {
        char c = '\u001b';
        String string = "]";
        String string2 = CharUtils.toHumanReadableText(c + string + this.text);
        Intrinsics.checkNotNullExpressionValue(string2, "toHumanReadableText(...)");
        return string2;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0002J \u0010\f\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0005H\u0002J\u0010\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/jediterm/terminal/emulator/SystemCommandSequence$Companion;", "", "<init>", "()V", "ST", "", "ARG_SEPARATOR", "OSC", "isTerminated", "", "text", "", "isTwoBytesTerminator", "length", "", "lastChar", "terminatorLength", "core"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean isTerminated(CharSequence text) {
            int len = text.length();
            if (len > 0) {
                char ch = text.charAt(len - 1);
                return ch == '\u0007' || ch == '\u009c' || this.isTwoBytesTerminator(text, len, ch);
            }
            return false;
        }

        private final boolean isTwoBytesTerminator(CharSequence text, int length, char lastChar) {
            return lastChar == '\\' && length >= 2 && text.charAt(length - 2) == '\u001b';
        }

        private final int terminatorLength(CharSequence text) {
            int length = text.length();
            return this.isTwoBytesTerminator(text, length, text.charAt(length - 1)) ? 2 : 1;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

