/*
 * Decompiled with CFR 0.152.
 */
package superhb.arcademod.client.gui;

import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.Gui;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;
import superhb.arcademod.api.gui.GuiArcade;
import superhb.arcademod.client.tileentity.TileEntityArcade;
import superhb.arcademod.util.KeyHandler;

public class GuiKong
extends GuiArcade {
    private static ResourceLocation texture = new ResourceLocation("arcademod:textures/gui/kong.png");
    private static int GUI_WIDTH = 236;
    private static int GUI_HEIGHT = 268;
    private static int PLATFORM_WIDTH = 16;
    private static int PLATFORM_HEIGHT = 8;
    private static int LADDER_WIDTH = 8;
    private static int LADDER_HEIGHT = 52;
    private static int KONG_WIDTH = 48;
    private static int KONG_HEIGHT = 36;
    private static int GIRL_WIDTH = 15;
    private static int GIRL_HEIGHT = 22;
    private static int BARREL_TOP_WIDTH = 12;
    private static int BARREL_TOP_HIEGHT = 10;
    private static int BARREL_LENGTH = 16;
    private static int BARREL_WIDTH = 10;
    private static int OIL = 16;
    private static int FLAME_WIDTH = 16;
    private static int FLAME_HIEGHT = 15;
    private int boardX;
    private int boardY;
    private int barrelTick;
    private int barrelAnim;
    private ArrayList<Point> collisionBoxes = new ArrayList();
    private ArrayList<Ladder> ladders = new ArrayList();
    private Player player;

    public GuiKong(World world, TileEntityArcade tileEntity, EntityPlayer player) {
        super(world, tileEntity, null, player);
        this.func_183500_a(GUI_WIDTH, GUI_HEIGHT);
        this.setTexture(texture, 512, 512);
        this.setOffset(0, 0);
        this.setButtonPos(GUI_WIDTH / 2 - this.buttonWidth / 2 - 30, GUI_HEIGHT - 32);
        this.setStartMenu(0);
        this.setCost(2);
        this.inMenu = false;
        this.createCollisionBoxes();
        this.createLadderCollisionBoxes();
        this.player = new Player();
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        if (!this.inMenu) {
            ++this.barrelTick;
            if (this.barrelTick == 10) {
                this.barrelAnim = this.barrelAnim == 3 ? 0 : ++this.barrelAnim;
                this.barrelTick = 0;
            }
            this.player.move();
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTick) {
        this.boardX = this.xScaled - GUI_WIDTH / 2 + 6;
        this.boardY = this.yScaled - GUI_HEIGHT / 2 + 6;
        super.func_73863_a(mouseX, mouseY, partialTick);
        if (!this.inMenu) {
            this.drawPlatforms();
            this.drawLadders();
            this.drawOil();
            for (Point p : this.collisionBoxes) {
                GuiKong.func_146110_a((int)(this.boardX + p.x), (int)(this.boardY + p.y), (float)496.0f, (float)510.0f, (int)16, (int)2, (float)512.0f, (float)512.0f);
            }
            for (Ladder l : this.ladders) {
                GuiKong.func_146110_a((int)(this.boardX + l.x), (int)(this.boardY + l.y), (float)504.0f, (float)506.0f, (int)LADDER_WIDTH, (int)2, (float)512.0f, (float)512.0f);
                GuiKong.func_146110_a((int)(this.boardX + l.x), (int)(this.boardY + l.y + l.length - 2), (float)504.0f, (float)508.0f, (int)LADDER_WIDTH, (int)2, (float)512.0f, (float)512.0f);
            }
            GuiKong.func_146110_a((int)(this.boardX + 24), (int)(this.boardY + 52), (float)0.0f, (float)GUI_HEIGHT, (int)KONG_WIDTH, (int)KONG_HEIGHT, (float)512.0f, (float)512.0f);
            GuiKong.func_146110_a((int)(this.boardX + 88), (int)(this.boardY + 34), (float)(GUI_WIDTH + LADDER_WIDTH), (float)BARREL_TOP_HIEGHT, (int)GIRL_WIDTH, (int)GIRL_HEIGHT, (float)512.0f, (float)512.0f);
            this.player.draw();
        }
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (!this.inMenu) {
            if (keyCode == KeyHandler.left.func_151463_i()) {
                this.player.setDirection(Direction.LEFT);
            }
            if (keyCode == KeyHandler.right.func_151463_i()) {
                this.player.setDirection(Direction.RIGHT);
            }
            if (keyCode == KeyHandler.jump.func_151463_i()) {
                this.player.setDirection(Direction.JUMP);
            }
            if (keyCode == KeyHandler.up.func_151463_i()) {
                this.player.setDirection(Direction.UP);
            }
        }
        super.func_73869_a(typedChar, keyCode);
    }

    private void drawPlatforms() {
        int i;
        for (i = 0; i < 7; ++i) {
            this.drawPlatform(i * PLATFORM_WIDTH, 248);
            this.drawPlatform(PLATFORM_WIDTH * 7 + i * PLATFORM_WIDTH, 247 - i);
        }
        for (i = 0; i < 13; ++i) {
            this.drawPlatform(i * PLATFORM_WIDTH, 208 + i);
            this.drawPlatform(i * PLATFORM_WIDTH + PLATFORM_WIDTH, 187 - i);
            this.drawPlatform(i * PLATFORM_WIDTH, 142 + i);
            this.drawPlatform(i * PLATFORM_WIDTH + PLATFORM_WIDTH, 121 - i);
        }
        for (i = 0; i < 9; ++i) {
            this.drawPlatform(i * PLATFORM_WIDTH, 84);
        }
        for (i = 0; i < 4; ++i) {
            this.drawPlatform(i * PLATFORM_WIDTH + PLATFORM_WIDTH * 9, 85 + i);
        }
        for (i = 0; i < 3; ++i) {
            this.drawPlatform(88 + i * PLATFORM_WIDTH, 56);
        }
    }

    private void drawLadders() {
        this.drawLadder(64, 32);
        this.drawLadder(80, 32);
        this.drawLadder(128, 64, 0, 20);
        this.drawLadder(88, 92, 0, 4);
        this.drawLadder(88, 104, 0, 13);
        this.drawLadder(184, 95, 3, 16);
        this.drawLadder(32, 128, 0, 16);
        this.drawLadder(72, 126, 2, 20);
        this.drawLadder(168, 120, 0, 8);
        this.drawLadder(168, 144, 0, 8);
        this.drawLadder(64, 154, 2, 6);
        this.drawLadder(64, 176, 0, 8);
        this.drawLadder(112, 157, 1, 24);
        this.drawLadder(184, 161, 1, 16);
        this.drawLadder(32, 194, 0, 16);
        this.drawLadder(96, 190, 2, 24);
        this.drawLadder(80, 221, 1, 3);
        this.drawLadder(80, 240, 0, 8);
        this.drawLadder(184, 227, 3, 16);
    }

    private void drawLadder(int x, int y) {
        this.drawLadder(x, y, 0, LADDER_HEIGHT);
    }

    private void drawLadder(int x, int y, int offset, int length) {
        GuiKong.func_146110_a((int)(this.boardX + x), (int)(this.boardY + y), (float)GUI_WIDTH, (float)(BARREL_TOP_HIEGHT + offset), (int)LADDER_WIDTH, (int)length, (float)512.0f, (float)512.0f);
    }

    private void drawPlatform(int x, int y) {
        GuiKong.func_146110_a((int)(this.boardX + x), (int)(this.boardY + y), (float)GUI_WIDTH, (float)0.0f, (int)PLATFORM_WIDTH, (int)PLATFORM_HEIGHT, (float)512.0f, (float)512.0f);
    }

    private void drawOil() {
        GuiKong.func_146110_a((int)(this.boardX + 16), (int)(this.boardY + 232), (float)(GUI_WIDTH + LADDER_WIDTH + GIRL_WIDTH * 2), (float)BARREL_TOP_HIEGHT, (int)OIL, (int)OIL, (float)512.0f, (float)512.0f);
        GuiKong.func_146110_a((int)(this.boardX + 17), (int)(this.boardY + 217), (float)(GUI_WIDTH + LADDER_WIDTH + GIRL_WIDTH * 2 + OIL + BARREL_WIDTH + this.barrelAnim * FLAME_WIDTH), (float)BARREL_TOP_HIEGHT, (int)FLAME_WIDTH, (int)FLAME_HIEGHT, (float)512.0f, (float)512.0f);
    }

    private void createCollisionBoxes() {
        int i;
        for (i = 0; i < 7; ++i) {
            this.collisionBoxes.add(new Point(i * PLATFORM_WIDTH, 248));
            this.collisionBoxes.add(new Point(PLATFORM_WIDTH * 7 + i * PLATFORM_WIDTH, 247 - i));
        }
        for (i = 0; i < 13; ++i) {
            this.collisionBoxes.add(new Point(i * PLATFORM_WIDTH, 208 + i));
            this.collisionBoxes.add(new Point(i * PLATFORM_WIDTH + PLATFORM_WIDTH, 187 - i));
            this.collisionBoxes.add(new Point(i * PLATFORM_WIDTH, 142 + i));
            this.collisionBoxes.add(new Point(i * PLATFORM_WIDTH + PLATFORM_WIDTH, 121 - i));
        }
        for (i = 0; i < 9; ++i) {
            this.collisionBoxes.add(new Point(i * PLATFORM_WIDTH, 84));
        }
        for (i = 0; i < 4; ++i) {
            this.collisionBoxes.add(new Point(i * PLATFORM_WIDTH + PLATFORM_WIDTH * 9, 85 + i));
        }
        for (i = 0; i < 3; ++i) {
            this.collisionBoxes.add(new Point(88 + i * PLATFORM_WIDTH, 56));
        }
    }

    private void createLadderCollisionBoxes() {
        this.ladders.add(new Ladder(64, 32));
        this.ladders.add(new Ladder(80, 32));
        this.ladders.add(new Ladder(128, 64, 20));
        this.ladders.add(new Ladder(88, 92, 4));
        this.ladders.add(new Ladder(88, 104, 13));
        this.ladders.add(new Ladder(184, 95, 16));
        this.ladders.add(new Ladder(32, 128, 16));
        this.ladders.add(new Ladder(72, 126, 20));
        this.ladders.add(new Ladder(168, 120, 8));
        this.ladders.add(new Ladder(168, 144, 8));
        this.ladders.add(new Ladder(64, 154, 6));
        this.ladders.add(new Ladder(64, 176, 8));
        this.ladders.add(new Ladder(112, 157, 24));
        this.ladders.add(new Ladder(184, 161, 16));
        this.ladders.add(new Ladder(32, 194, 16));
        this.ladders.add(new Ladder(96, 190, 24));
        this.ladders.add(new Ladder(80, 221, 3));
        this.ladders.add(new Ladder(80, 240, 8));
        this.ladders.add(new Ladder(184, 227, 16));
    }

    private class Ladder {
        int x;
        int y;
        int length;

        public Ladder(int x, int y) {
            this.x = x;
            this.y = y;
            this.length = LADDER_HEIGHT;
        }

        public Ladder(int x, int y, int length) {
            this.x = x;
            this.y = y;
            this.length = length;
        }
    }

    private static enum Direction {
        STAND(0, 0, 0),
        UP(1, 2, 1),
        DOWN(2, 1, 1),
        LEFT(3, 4, 2),
        RIGHT(4, 3, 2),
        JUMP(5, 0, 1);

        private int direction;
        private int opposite;
        private int axis;

        private Direction(int direction, int opposite, int axis) {
            this.direction = direction;
            this.opposite = opposite;
            this.axis = axis;
        }

        public int getDirection() {
            return this.direction;
        }

        public Direction getOpposite() {
            return Direction.values()[this.opposite];
        }

        public int getAxis() {
            return this.axis;
        }
    }

    private class Barrel {
        private boolean isFlaming;
        private int x;
        private int y;
        private int rollState;

        private Barrel(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void move() {
        }

        public void draw() {
        }

        public boolean canMoveLeft() {
            return false;
        }

        public boolean canMoveRight() {
            return false;
        }

        public boolean canFall() {
            return false;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }

    private class Player {
        private int lives = 3;
        private int x;
        private int y;
        private int jumpTick = 0;
        private boolean canClimb;
        private boolean isClimbing;
        private boolean isJumping;
        private Direction direction = Direction.STAND;

        private Player() {
            this.x = 20;
            this.y = 232;
        }

        private Player(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public void move() {
            if (!this.isOnGround() && !this.isClimbing) {
                ++this.y;
            }
            if (this.isOnGround()) {
                this.isClimbing = false;
            }
            switch (this.direction) {
                case RIGHT: {
                    this.isClimbing = false;
                    if (this.canMoveRight() && Keyboard.isKeyDown((int)KeyHandler.right.func_151463_i())) {
                        ++this.x;
                        for (Point p : GuiKong.this.collisionBoxes) {
                            if (this.x + 8 != p.x || this.y + 15 != p.y) continue;
                            --this.y;
                        }
                        break;
                    }
                    this.setDirection(Direction.STAND);
                    break;
                }
                case LEFT: {
                    this.isClimbing = false;
                    if (this.canMoveLeft() && Keyboard.isKeyDown((int)KeyHandler.left.func_151463_i())) {
                        --this.x;
                        for (Point p : GuiKong.this.collisionBoxes) {
                            if (this.x != p.x || this.y + 15 != p.y) continue;
                            --this.y;
                        }
                        break;
                    }
                    this.setDirection(Direction.STAND);
                    break;
                }
                case JUMP: {
                    this.isClimbing = false;
                    if (!this.canJump() && !this.isJumping) break;
                    this.isJumping = true;
                    if (this.jumpTick == 0) {
                        this.jumpTick = GuiKong.this.tickCounter;
                    }
                    if (GuiKong.this.tickCounter - this.jumpTick <= 10) {
                        this.y -= 2;
                        break;
                    }
                    this.setDirection(Direction.STAND);
                    this.isJumping = false;
                    this.jumpTick = 0;
                    break;
                }
                case UP: {
                    if (this.canClimbUp() && Keyboard.isKeyDown((int)KeyHandler.up.func_151463_i())) {
                        this.isClimbing = true;
                        --this.y;
                        break;
                    }
                    this.setDirection(Direction.STAND);
                    break;
                }
                case DOWN: {
                    if (this.canClimbDown() && Keyboard.isKeyDown((int)KeyHandler.down.func_151463_i())) {
                        this.isClimbing = true;
                        ++this.y;
                        break;
                    }
                    this.setDirection(Direction.STAND);
                    break;
                }
            }
        }

        public void setDirection(Direction direction) {
            this.direction = direction;
        }

        public void draw() {
            Gui.func_146110_a((int)(GuiKong.this.boardX + this.x), (int)(GuiKong.this.boardY + this.y), (float)0.0f, (float)(GUI_HEIGHT + 3 * KONG_HEIGHT), (int)16, (int)16, (float)512.0f, (float)512.0f);
        }

        public boolean canMoveLeft() {
            return GuiKong.this.boardX + this.x != GuiKong.this.boardX;
        }

        public boolean canMoveRight() {
            return GuiKong.this.boardX + this.x != GuiKong.this.boardX + 212;
        }

        public boolean isOnGround() {
            for (Point p : GuiKong.this.collisionBoxes) {
                if (this.x + 8 < p.x || this.y + 16 != p.y) continue;
                return true;
            }
            return false;
        }

        public boolean canClimbUp() {
            for (Ladder l : GuiKong.this.ladders) {
                if (this.x + 4 < l.x || this.x + 4 > l.x + LADDER_WIDTH || this.y + 15 < l.y || this.y + 15 > l.y + l.length) continue;
                return true;
            }
            return false;
        }

        public boolean canClimbDown() {
            for (Ladder l : GuiKong.this.ladders) {
                if (this.x + 4 < l.x || this.x + 4 > l.x + LADDER_WIDTH || this.y + 15 < l.y || this.y + 15 > l.y + l.length) continue;
                return true;
            }
            return false;
        }

        public boolean canJump() {
            return this.isOnGround();
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }
}

