/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.common.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.relauncher.ReflectionHelper;

public class BOPReflectionHelper {
    public static <T> T construct(Class<T> clazz, Object ... args) {
        Constructor<T> constructor = BOPReflectionHelper.getConstructor(clazz, args);
        try {
            constructor.setAccessible(true);
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Object ... args) {
        int len = args.length;
        for (Constructor<?> constructor : clazz.getDeclaredConstructors()) {
            Class<?>[] constructorArgTypes = constructor.getParameterTypes();
            if (constructorArgTypes.length != len) continue;
            boolean match = true;
            for (int i = 0; i < len; ++i) {
                if (constructorArgTypes[i].isInstance(args[i])) continue;
                match = false;
            }
            if (!match) continue;
            return constructor;
        }
        return null;
    }

    public static <T, E> void setPrivateFinalValue(Class<? super T> classToAccess, T instance, E value, String ... fieldNames) {
        Field field = ReflectionHelper.findField(classToAccess, (String[])ObfuscationReflectionHelper.remapFieldNames((String)classToAccess.getName(), (String[])fieldNames));
        try {
            Field modifiersField = Field.class.getDeclaredField("modifiers");
            modifiersField.setAccessible(true);
            modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
            field.set(instance, value);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

