/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.furniture.init;

import com.google.gson.JsonObject;
import com.mrcrayfish.furniture.handler.FuelHandler;
import com.mrcrayfish.furniture.init.FurnitureItems;
import com.mrcrayfish.furniture.init.RegistrationHandler;
import com.mrcrayfish.furniture.util.RecipeUtil;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.IFuelHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.oredict.ShapelessOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class FurnitureCrafting {
    public static void register() {
        GameRegistry.addSmelting((Item)FurnitureItems.FLESH, (ItemStack)new ItemStack(FurnitureItems.COOKED_FLESH), (float)0.05f);
        GameRegistry.registerFuelHandler((IFuelHandler)new FuelHandler());
        RegistrationHandler.Recipes.add((IRecipe)new RecipeSoapyWater().setRegistryName("cfm:recipe_soapy_water"));
    }

    private static class RecipeCuttingShapeless
    extends ShapelessOreRecipe {
        private Random random = new Random();

        public RecipeCuttingShapeless(ResourceLocation group, NonNullList<Ingredient> input, ItemStack result) {
            super(group, input, result);
        }

        private ItemStack damageTool(ItemStack stack) {
            EntityPlayer craftingPlayer = ForgeHooks.getCraftingPlayer();
            if (stack.func_96631_a(1, this.random, craftingPlayer instanceof EntityPlayerMP ? (EntityPlayerMP)craftingPlayer : null)) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)craftingPlayer, (ItemStack)stack, null);
                return ItemStack.field_190927_a;
            }
            return stack;
        }

        public NonNullList<ItemStack> func_179532_b(InventoryCrafting inventoryCrafting) {
            NonNullList remainingItems = NonNullList.func_191197_a((int)inventoryCrafting.func_70302_i_(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < remainingItems.size(); ++i) {
                ItemStack itemstack = inventoryCrafting.func_70301_a(i);
                if (!itemstack.func_190926_b() && itemstack.func_77973_b().func_77645_m()) {
                    remainingItems.set(i, (Object)this.damageTool(itemstack.func_77946_l()));
                    continue;
                }
                remainingItems.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
            }
            return remainingItems;
        }

        public static class Factory
        implements IRecipeFactory {
            public IRecipe parse(JsonContext context, JsonObject json) {
                String group = JsonUtils.func_151219_a((JsonObject)json, (String)"group", (String)"");
                NonNullList<Ingredient> ingredients = RecipeUtil.parseShapeless(context, json);
                ItemStack result = CraftingHelper.getItemStack((JsonObject)JsonUtils.func_152754_s((JsonObject)json, (String)"result"), (JsonContext)context);
                return new RecipeCuttingShapeless(group.isEmpty() ? null : new ResourceLocation(group), ingredients, result);
            }
        }
    }

    private static class RecipeSoapyWater
    extends IForgeRegistryEntry.Impl<IRecipe>
    implements IRecipe {
        private RecipeSoapyWater() {
        }

        public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
            int i;
            int size = 0;
            for (i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                ++size;
            }
            for (i = 0; i < inv.func_70302_i_() - inv.func_174922_i(); ++i) {
                ItemStack below;
                ItemStack above = inv.func_70301_a(i);
                if (above.func_190926_b() || above.func_77973_b() != FurnitureItems.SOAP || (below = inv.func_70301_a(i + inv.func_174922_i())).func_190926_b() || below.func_77973_b() != Items.field_151131_as) continue;
                return size == 2;
            }
            return false;
        }

        public ItemStack func_77572_b(InventoryCrafting inv) {
            return new ItemStack(FurnitureItems.SOAPY_WATER);
        }

        public boolean func_194133_a(int width, int height) {
            return width > 0 && height > 1;
        }

        public ItemStack func_77571_b() {
            return new ItemStack(FurnitureItems.SOAPY_WATER);
        }

        public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
            NonNullList items = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
            for (int i = 0; i < inv.func_70302_i_(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b() || stack.func_77973_b() != FurnitureItems.SOAP) continue;
                ItemStack soap = stack.func_77946_l();
                soap.func_190918_g(1);
                items.set(i, (Object)soap);
                break;
            }
            inv.func_174888_l();
            return items;
        }
    }
}

