/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.object.tiles;

import com.mrcrayfish.device.api.utils.RenderUtil;
import com.mrcrayfish.device.object.Game;
import com.mrcrayfish.device.object.tiles.Tile;
import org.lwjgl.opengl.GL11;

public class TileGrass
extends Tile {
    public TileGrass(int id, int x, int y) {
        super(id, x, y);
    }

    @Override
    public void render(Game game, int x, int y, Game.Layer layer) {
        super.render(game, x, y, layer);
        if (!game.isFullTile(layer, x, y + 1)) {
            GL11.glColor4f((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
            RenderUtil.drawRectWithTexture(game.xPosition + x * 8, game.yPosition + y * 6 + 6, Tile.dirt.x * 16, Tile.dirt.y * 16, 8, 6, 16.0f, 16.0f);
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    @Override
    public void renderForeground(Game game, int x, int y, Game.Layer layer) {
        super.renderForeground(game, x, y, layer);
        if (game.getTile(layer, x, y - 1) == Tile.water) {
            RenderUtil.drawRectWithTexture(game.xPosition + x * 8, game.yPosition + y * 6 - 1, 16.0f, 16.0f, 8, 1, 16.0f, 2.0f);
        }
        if (game.getTile(layer, x, y + 1) == Tile.water) {
            RenderUtil.drawRectWithTexture(game.xPosition + x * 8, game.yPosition + y * 6 + 6, 16.0f, 18.0f, 8, 3, 16.0f, 6.0f);
        }
        if (game.getTile(layer, x - 1, y) == Tile.water) {
            RenderUtil.drawRectWithTexture(game.xPosition + x * 8 - 1, game.yPosition + y * 6, 0.0f, 16.0f, 1, 6, 2.0f, 12.0f);
        }
        if (game.getTile(layer, x + 1, y) == Tile.water) {
            RenderUtil.drawRectWithTexture(game.xPosition + x * 8 + 8, game.yPosition + y * 6, 2.0f, 16.0f, 1, 6, 2.0f, 12.0f);
        }
    }

    @Override
    public boolean isSlow() {
        return true;
    }
}

