/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.init;

import com.mrcrayfish.device.block.BlockLaptop;
import com.mrcrayfish.device.block.BlockOfficeChair;
import com.mrcrayfish.device.block.BlockPaper;
import com.mrcrayfish.device.block.BlockPrinter;
import com.mrcrayfish.device.block.BlockRouter;
import com.mrcrayfish.device.init.RegistrationHandler;
import com.mrcrayfish.device.item.ItemColoredDevice;
import com.mrcrayfish.device.item.ItemPaper;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;

public class DeviceBlocks {
    public static final Block LAPTOP = new BlockLaptop();
    public static final Block ROUTER = new BlockRouter();
    public static final Block PRINTER = new BlockPrinter();
    public static final Block PAPER = new BlockPaper();
    public static final Block OFFICE_CHAIR = new BlockOfficeChair();

    public static void register() {
        DeviceBlocks.registerBlock(LAPTOP, new ItemColoredDevice(LAPTOP));
        DeviceBlocks.registerBlock(ROUTER, new ItemColoredDevice(ROUTER));
        DeviceBlocks.registerBlock(PRINTER, new ItemColoredDevice(PRINTER));
        DeviceBlocks.registerBlock(PAPER, new ItemPaper(PAPER));
        DeviceBlocks.registerBlock(OFFICE_CHAIR, new ItemColoredDevice(OFFICE_CHAIR));
    }

    private static void registerBlock(Block block) {
        DeviceBlocks.registerBlock(block, new ItemBlock(block));
    }

    private static void registerBlock(Block block, ItemBlock item) {
        if (block.getRegistryName() == null) {
            throw new IllegalArgumentException("A block being registered does not have a registry name and could be successfully registered.");
        }
        RegistrationHandler.Blocks.add(block);
        item.setRegistryName(block.getRegistryName());
        RegistrationHandler.Items.add((Item)item);
    }
}

