/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.core.io.task;

import com.mrcrayfish.device.api.io.Folder;
import com.mrcrayfish.device.api.task.Task;
import com.mrcrayfish.device.core.io.FileSystem;
import com.mrcrayfish.device.core.io.ServerFile;
import com.mrcrayfish.device.core.io.ServerFolder;
import com.mrcrayfish.device.core.io.drive.AbstractDrive;
import com.mrcrayfish.device.tileentity.TileEntityLaptop;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class TaskGetFiles
extends Task {
    private String uuid;
    private String path;
    private BlockPos pos;
    private List<ServerFile> files;

    private TaskGetFiles() {
        super("get_files");
    }

    public TaskGetFiles(Folder folder, BlockPos pos) {
        this();
        this.uuid = folder.getDrive().getUUID().toString();
        this.path = folder.getPath();
        this.pos = pos;
    }

    @Override
    public void prepareRequest(NBTTagCompound nbt) {
        nbt.func_74778_a("uuid", this.uuid);
        nbt.func_74778_a("path", this.path);
        nbt.func_74772_a("pos", this.pos.func_177986_g());
    }

    @Override
    public void processRequest(NBTTagCompound nbt, World world, EntityPlayer player) {
        TileEntity tileEntity = world.func_175625_s(BlockPos.func_177969_a((long)nbt.func_74763_f("pos")));
        if (tileEntity instanceof TileEntityLaptop) {
            ServerFolder found;
            TileEntityLaptop laptop = (TileEntityLaptop)tileEntity;
            FileSystem fileSystem = laptop.getFileSystem();
            UUID uuid = UUID.fromString(nbt.func_74779_i("uuid"));
            AbstractDrive serverDrive = fileSystem.getAvailableDrives(world, true).get(uuid);
            if (serverDrive != null && (found = serverDrive.getFolder(nbt.func_74779_i("path"))) != null) {
                this.files = found.getFiles().stream().filter(f -> !f.isFolder()).collect(Collectors.toList());
                this.setSuccessful();
            }
        }
    }

    @Override
    public void prepareResponse(NBTTagCompound nbt) {
        if (this.files != null) {
            NBTTagList list = new NBTTagList();
            this.files.forEach(f -> {
                NBTTagCompound fileTag = new NBTTagCompound();
                fileTag.func_74778_a("file_name", f.getName());
                fileTag.func_74782_a("data", (NBTBase)f.toTag());
                list.func_74742_a((NBTBase)fileTag);
            });
            nbt.func_74782_a("files", (NBTBase)list);
        }
    }

    @Override
    public void processResponse(NBTTagCompound nbt) {
    }

    protected static String compileDirectory(ServerFile file) {
        if (file.getParent() == null || file.getParent().getParent() == null) {
            return "/";
        }
        StringBuilder builder = new StringBuilder();
        for (ServerFolder parent = file.getParent(); parent != null; parent = parent.getParent()) {
            builder.insert(0, "/" + parent.getName());
            if (parent.getParent() == null) continue;
            return builder.toString();
        }
        return builder.toString();
    }
}

