/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.core;

import com.mrcrayfish.device.MrCrayfishDeviceMod;
import com.mrcrayfish.device.api.app.Application;
import com.mrcrayfish.device.api.utils.RenderUtil;
import com.mrcrayfish.device.core.Laptop;
import com.mrcrayfish.device.core.network.TrayItemWifi;
import com.mrcrayfish.device.object.AppInfo;
import com.mrcrayfish.device.object.TrayItem;
import com.mrcrayfish.device.programs.system.ApplicationAppStore;
import com.mrcrayfish.device.programs.system.ApplicationFileBrowser;
import com.mrcrayfish.device.programs.system.ApplicationSettings;
import com.mrcrayfish.device.programs.system.SystemApplication;
import com.mrcrayfish.device.util.Vulnerability;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class TaskBar {
    public static final ResourceLocation APP_BAR_GUI = new ResourceLocation("cdm:textures/gui/application_bar.png");
    private static final int APPS_DISPLAYED = 10;
    public static final int BAR_HEIGHT = 18;
    private Laptop laptop;
    private int offset = 0;
    private int pingTimer = 0;
    private List<TrayItem> trayItems = new ArrayList<TrayItem>();

    public TaskBar(Laptop laptop) {
        this.laptop = laptop;
        this.trayItems.add(new Vulnerability.VulnerabilityTrayItem());
        this.trayItems.add(new ApplicationFileBrowser.FileBrowserTrayItem());
        this.trayItems.add(new ApplicationSettings.SettingsTrayItem());
        this.trayItems.add(new ApplicationAppStore.StoreTrayItem());
        this.trayItems.add(new TrayItemWifi());
    }

    public void init() {
        this.trayItems.forEach(TrayItem::init);
    }

    public void setupApplications(List<Application> applications) {
        Predicate<Application> VALID_APPS = app -> {
            if (app instanceof SystemApplication) {
                return true;
            }
            if (MrCrayfishDeviceMod.proxy.hasAllowedApplications()) {
                return MrCrayfishDeviceMod.proxy.getAllowedApplications().contains(app.getInfo());
            }
            return true;
        };
    }

    public void init(int posX, int posY) {
        this.init();
    }

    public void onTick() {
        this.trayItems.forEach(TrayItem::tick);
    }

    public void render(Laptop laptop, Minecraft mc, int x, int y, int mouseX, int mouseY, float partialTicks) {
        int appIndex;
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.75f);
        GlStateManager.func_179147_l();
        mc.func_110434_K().func_110577_a(APP_BAR_GUI);
        Color bgColor = new Color(laptop.getSettings().getColorScheme().getBackgroundColor()).brighter().brighter();
        float[] hsb = Color.RGBtoHSB(bgColor.getRed(), bgColor.getGreen(), bgColor.getBlue(), null);
        bgColor = new Color(Color.HSBtoRGB(hsb[0], hsb[1], 1.0f));
        GL11.glColor4f((float)((float)bgColor.getRed() / 255.0f), (float)((float)bgColor.getGreen() / 255.0f), (float)((float)bgColor.getBlue() / 255.0f), (float)1.0f);
        int trayItemsWidth = this.trayItems.size() * 14;
        RenderUtil.drawRectWithTexture(x, y, 0.0f, 0.0f, 1, 18, 1.0f, 18.0f);
        RenderUtil.drawRectWithTexture(x + 1, y, 1.0f, 0.0f, 328 - trayItemsWidth, 18, 1.0f, 18.0f);
        RenderUtil.drawRectWithTexture(x + 364 - 35 - trayItemsWidth, y, 2.0f, 0.0f, 35 + trayItemsWidth, 18, 1.0f, 18.0f);
        GlStateManager.func_179084_k();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        for (int i = 0; i < 10 && i < laptop.installedApps.size(); ++i) {
            AppInfo info = laptop.installedApps.get(i + this.offset);
            RenderUtil.drawApplicationIcon(info, x + 2 + i * 16, y + 2);
            if (!laptop.isApplicationRunning(info)) continue;
            mc.func_110434_K().func_110577_a(APP_BAR_GUI);
            laptop.func_73729_b(x + 1 + i * 16, y + 1, 35, 0, 16, 16);
        }
        mc.field_71466_p.func_175065_a(this.timeToString(mc.field_71439_g.field_70170_p.func_72820_D()), (float)(x + 334), (float)(y + 5), Color.WHITE.getRGB(), true);
        int startX = x + 317;
        for (int i = 0; i < this.trayItems.size(); ++i) {
            int posX = startX - (this.trayItems.size() - 1 - i) * 14;
            if (this.isMouseInside(mouseX, mouseY, posX, y + 2, posX + 13, y + 15)) {
                Gui.func_73734_a((int)posX, (int)(y + 2), (int)(posX + 14), (int)(y + 16), (int)new Color(1.0f, 1.0f, 1.0f, 0.1f).getRGB());
            }
            this.trayItems.get(i).getIcon().draw(mc, posX + 2, y + 4);
        }
        mc.func_110434_K().func_110577_a(APP_BAR_GUI);
        if (this.isMouseInside(mouseX, mouseY, x + 1, y + 1, x + 236, y + 16) && (appIndex = (mouseX - x - 1) / 16) >= 0 && appIndex < this.offset + 10 && appIndex < laptop.installedApps.size()) {
            laptop.func_73729_b(x + appIndex * 16 + 1, y + 1, 35, 0, 16, 16);
            laptop.func_146283_a(Collections.singletonList(laptop.installedApps.get(appIndex).getName()), mouseX, mouseY);
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderHelper.func_74518_a();
    }

    public void handleClick(Laptop laptop, int x, int y, int mouseX, int mouseY, int mouseButton) {
        int appIndex;
        if (this.isMouseInside(mouseX, mouseY, x + 1, y + 1, x + 236, y + 16) && (appIndex = (mouseX - x - 1) / 16) >= 0 && appIndex <= this.offset + 10 && appIndex < laptop.installedApps.size()) {
            laptop.openApplication(laptop.installedApps.get(appIndex));
            return;
        }
        int startX = x + 317;
        for (int i = 0; i < this.trayItems.size(); ++i) {
            int posX = startX - (this.trayItems.size() - 1 - i) * 14;
            if (!this.isMouseInside(mouseX, mouseY, posX, y + 2, posX + 13, y + 15)) continue;
            this.trayItems.get(i).handleClick(mouseX, mouseY, mouseButton);
            break;
        }
    }

    public boolean isMouseInside(int mouseX, int mouseY, int x1, int y1, int x2, int y2) {
        return mouseX >= x1 && mouseX <= x2 && mouseY >= y1 && mouseY <= y2;
    }

    public String timeToString(long time) {
        int hours = (int)((Math.floor((double)time / 1000.0) + 7.0) % 24.0);
        int minutes = (int)Math.floor((double)(time % 1000L) / 1000.0 * 60.0);
        return String.format("%02d:%02d", hours, minutes);
    }
}

