/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.block;

import com.mrcrayfish.device.MrCrayfishDeviceMod;
import com.mrcrayfish.device.block.BlockDevice;
import com.mrcrayfish.device.init.DeviceItems;
import com.mrcrayfish.device.object.Bounds;
import com.mrcrayfish.device.tileentity.TileEntityLaptop;
import com.mrcrayfish.device.util.TileEntityUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockColored;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockLaptop
extends BlockDevice.Colored {
    public static final PropertyEnum TYPE = PropertyEnum.func_177709_a((String)"type", Type.class);
    private static final AxisAlignedBB[] SCREEN_BOXES = new Bounds(0.8125, 0.0625, 0.0625, 1.0, 0.75, 0.9375).getRotatedBounds();
    private static final AxisAlignedBB BODY_OPEN_BOX = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.8125, 0.0625, 0.9375);
    private static final AxisAlignedBB BODY_CLOSED_BOX = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.8125, 0.125, 0.9375);
    private static final AxisAlignedBB SELECTION_BOX_OPEN = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);
    private static final AxisAlignedBB SELECTION_BOX_CLOSED = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.1875, 1.0);

    public BlockLaptop() {
        super(Material.field_151574_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)field_185512_D, (Comparable)EnumFacing.NORTH).func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.BASE)));
        this.func_149647_a(MrCrayfishDeviceMod.TAB_DEVICE);
        this.func_149663_c("laptop");
        this.setRegistryName("laptop");
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        TileEntity tileEntity = source.func_175625_s(pos);
        if (tileEntity instanceof TileEntityLaptop) {
            TileEntityLaptop laptop = (TileEntityLaptop)tileEntity;
            if (laptop.isOpen()) {
                return SELECTION_BOX_OPEN;
            }
            return SELECTION_BOX_CLOSED;
        }
        return field_185505_j;
    }

    public void func_185477_a(IBlockState state, World worldIn, BlockPos pos, AxisAlignedBB entityBox, List<AxisAlignedBB> collidingBoxes, @Nullable Entity entityIn, boolean p_185477_7_) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityLaptop) {
            TileEntityLaptop laptop = (TileEntityLaptop)tileEntity;
            if (laptop.isOpen()) {
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BODY_OPEN_BOX);
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)SCREEN_BOXES[((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176736_b()]);
            } else {
                Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)BODY_CLOSED_BOX);
            }
            return;
        }
        Block.func_185492_a((BlockPos)pos, (AxisAlignedBB)entityBox, collidingBoxes, (AxisAlignedBB)field_185505_j);
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof TileEntityLaptop) {
            TileEntityLaptop laptop = (TileEntityLaptop)tileEntity;
            if (playerIn.func_70093_af()) {
                if (!worldIn.field_72995_K) {
                    laptop.openClose();
                }
            } else {
                if (side == ((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176735_f()) {
                    ItemStack stack;
                    ItemStack heldItem = playerIn.func_184586_b(hand);
                    if (!heldItem.func_190926_b() && heldItem.func_77973_b() == DeviceItems.FLASH_DRIVE) {
                        if (!worldIn.field_72995_K) {
                            if (laptop.getFileSystem().setAttachedDrive(heldItem.func_77946_l())) {
                                heldItem.func_190918_g(1);
                            } else {
                                playerIn.func_145747_a((ITextComponent)new TextComponentString("No more available USB slots!"));
                            }
                        }
                        return true;
                    }
                    if (!worldIn.field_72995_K && (stack = laptop.getFileSystem().removeAttachedDrive()) != null) {
                        BlockPos summonPos = pos.func_177972_a(((EnumFacing)state.func_177229_b((IProperty)field_185512_D)).func_176735_f());
                        worldIn.func_72838_d((Entity)new EntityItem(worldIn, (double)summonPos.func_177958_n() + 0.5, (double)summonPos.func_177956_o(), (double)summonPos.func_177952_p() + 0.5, stack));
                        TileEntityUtil.markBlockForUpdate(worldIn, pos);
                    }
                    return true;
                }
                if (laptop.isOpen() && worldIn.field_72995_K) {
                    playerIn.openGui((Object)MrCrayfishDeviceMod.instance, 1, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
                }
            }
        }
        return true;
    }

    @Override
    protected void removeTagsForDrop(NBTTagCompound tileEntityTag) {
        tileEntityTag.func_82580_o("open");
    }

    @Override
    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return super.func_176221_a(state, worldIn, pos).func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.BASE));
    }

    @Override
    public IBlockState func_176203_a(int meta) {
        return super.func_176203_a(meta).func_177226_a((IProperty)TYPE, (Comparable)((Object)Type.BASE));
    }

    @Override
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{field_185512_D, TYPE, BlockColored.field_176581_a});
    }

    @Override
    @Nullable
    public TileEntity createTileEntity(World world, IBlockState state) {
        return new TileEntityLaptop();
    }

    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public static enum Type implements IStringSerializable
    {
        BASE,
        SCREEN;


        public String func_176610_l() {
            return this.name().toLowerCase();
        }
    }
}

