/*
 * Decompiled with CFR 0.152.
 */
package com.mrcrayfish.device.api.io;

import com.mrcrayfish.device.api.app.Application;
import com.mrcrayfish.device.api.io.Drive;
import com.mrcrayfish.device.api.io.Folder;
import com.mrcrayfish.device.api.task.Callback;
import com.mrcrayfish.device.core.io.FileSystem;
import com.mrcrayfish.device.core.io.action.FileAction;
import com.mrcrayfish.device.programs.system.component.FileBrowser;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class File {
    public static final Comparator<File> SORT_BY_NAME = (f1, f2) -> {
        if (f1.isFolder() && !f2.isFolder()) {
            return -1;
        }
        if (!f1.isFolder() && f2.isFolder()) {
            return 1;
        }
        return f1.name.compareTo(f2.name);
    };
    protected Drive drive;
    protected Folder parent;
    protected String name;
    protected String openingApp;
    protected NBTTagCompound data;
    protected boolean protect = false;
    protected boolean valid = false;

    protected File() {
    }

    public File(String name, Application app, NBTTagCompound data) {
        this(name, app.getInfo().getFormattedId(), data, false);
    }

    public File(String name, String openingAppId, NBTTagCompound data) {
        this(name, openingAppId, data, false);
    }

    private File(String name, String openingAppId, NBTTagCompound data, boolean protect) {
        this.name = name;
        this.openingApp = openingAppId;
        this.data = data;
        this.protect = protect;
    }

    public String getName() {
        return this.name;
    }

    public void rename(String name) {
        this.rename(name, null);
    }

    public void rename(String name, @Nullable Callback<FileSystem.Response> callback) {
        if (!this.valid) {
            throw new IllegalStateException("File must be added to the system before you can rename it");
        }
        if (this.protect) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(3, "Cannot rename a protected file"), false);
            }
            return;
        }
        if (!FileSystem.PATTERN_FILE_NAME.matcher(name).matches()) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(5, "Invalid file name"), true);
            }
            return;
        }
        FileSystem.sendAction(this.drive, FileAction.Factory.makeRename(this, name), (response, success) -> {
            if (success) {
                this.name = name;
            }
            if (callback != null) {
                callback.execute((FileSystem.Response)response, success);
            }
        });
    }

    public String getPath() {
        if (this.parent == null) {
            return "/";
        }
        StringBuilder builder = new StringBuilder();
        for (File current = this; current != null && current.getParent() != null; current = current.getParent()) {
            builder.insert(0, "/" + current.getName());
        }
        return builder.toString();
    }

    public String getLocation() {
        if (this.parent == null) {
            throw new NullPointerException("File must have a parent to compile the directory");
        }
        StringBuilder builder = new StringBuilder();
        for (Folder current = this.parent; current != null && current.getParent() != null; current = current.getParent()) {
            builder.insert(0, "/" + current.getName());
        }
        return builder.toString();
    }

    @Nullable
    public String getOpeningApp() {
        return this.openingApp;
    }

    public void setData(NBTTagCompound data) {
        this.setData(data, null);
    }

    public void setData(NBTTagCompound data, @Nullable Callback<FileSystem.Response> callback) {
        if (!this.valid) {
            throw new IllegalStateException("File must be added to the system before you can rename it");
        }
        if (this.protect) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(3, "Cannot set data on a protected file"), false);
            }
            return;
        }
        if (data == null) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(6, "Invalid data"), false);
            }
            return;
        }
        FileSystem.sendAction(this.drive, FileAction.Factory.makeData(this, data), (response, success) -> {
            if (success) {
                this.data = data.func_74737_b();
            }
            if (callback != null) {
                callback.execute((FileSystem.Response)response, success);
            }
        });
    }

    @Nullable
    public NBTTagCompound getData() {
        return this.data.func_74737_b();
    }

    @Nullable
    public Folder getParent() {
        return this.parent;
    }

    public Drive getDrive() {
        return this.drive;
    }

    void setDrive(Drive drive) {
        this.drive = drive;
    }

    public boolean isProtected() {
        return this.protect;
    }

    public boolean isFolder() {
        return false;
    }

    public boolean isForApplication(Application app) {
        return this.openingApp != null && this.openingApp.equals(app.getInfo().getFormattedId());
    }

    public void delete() {
        this.delete(null);
    }

    public void delete(@Nullable Callback<FileSystem.Response> callback) {
        if (!this.valid) {
            throw new IllegalStateException("File must be added to the system before you can rename it");
        }
        if (this.protect) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(3, "Cannot delete a protected file"), false);
            }
            return;
        }
        if (this.parent != null) {
            this.parent.delete(this, callback);
        }
    }

    public void copyTo(Folder destination, boolean override, @Nullable Callback<FileSystem.Response> callback) {
        if (destination == null) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(2, "Illegal folder"), false);
            }
            return;
        }
        if (!destination.valid || destination.drive == null) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(2, "Destination folder is invalid"), false);
            }
            return;
        }
        if (!this.valid || this.drive == null) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(2, "Source file is invalid"), false);
            }
            return;
        }
        if (destination.hasFile(this.name)) {
            if (!override) {
                if (callback != null) {
                    callback.execute(FileSystem.createResponse(4, "A file with that name already exists"), false);
                }
                return;
            }
            if (destination.getFile(this.name).isProtected()) {
                if (callback != null) {
                    callback.execute(FileSystem.createResponse(3, "Unable to override protected files"), false);
                }
                return;
            }
        }
        FileSystem.sendAction(this.drive, FileAction.Factory.makeCopyCut(this, destination, override, false), (response, success) -> {
            if (response.getStatus() == 1) {
                if (override) {
                    destination.files.remove(destination.getFile(this.name));
                }
                File file = this.copy();
                file.valid = true;
                file.parent = destination;
                file.setDrive(destination.drive);
                destination.files.add(file);
                FileBrowser.refreshList = true;
            }
            if (callback != null) {
                callback.execute((FileSystem.Response)response, success);
            }
        });
    }

    public void moveTo(Folder destination, boolean override, @Nullable Callback<FileSystem.Response> callback) {
        if (destination == null) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(2, "Illegal folder"), false);
            }
            return;
        }
        if (!destination.valid || destination.drive == null) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(2, "Destination folder is invalid"), false);
            }
            return;
        }
        if (!this.valid || this.drive == null) {
            if (callback != null) {
                callback.execute(FileSystem.createResponse(2, "Source file is invalid"), false);
            }
            return;
        }
        if (this.equals(destination.getFile(this.name))) {
            if (callback != null) {
                callback.execute(FileSystem.createSuccessResponse(), false);
            }
            return;
        }
        if (destination.hasFile(this.name)) {
            if (!override) {
                if (callback != null) {
                    callback.execute(FileSystem.createResponse(4, "A file with that name already exists"), false);
                }
                return;
            }
            if (destination.getFile(this.name).isProtected()) {
                if (callback != null) {
                    callback.execute(FileSystem.createResponse(3, "Unable to override protected files"), false);
                }
                return;
            }
        }
        FileSystem.sendAction(this.drive, FileAction.Factory.makeCopyCut(this, destination, override, true), (response, success) -> {
            if (response.getStatus() == 1) {
                if (override) {
                    destination.files.remove(destination.getFile(this.name));
                }
                this.parent.files.remove(this);
                this.setDrive(destination.drive);
                this.parent = destination;
                destination.files.add(this);
                FileBrowser.refreshList = true;
            }
            if (callback != null) {
                callback.execute((FileSystem.Response)response, success);
            }
        });
    }

    public NBTTagCompound toTag() {
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74778_a("openingApp", this.openingApp);
        tag.func_74782_a("data", (NBTBase)this.data);
        return tag;
    }

    public static File fromTag(String name, NBTTagCompound tag) {
        return new File(name, tag.func_74779_i("openingApp"), tag.func_74775_l("data"));
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof File)) {
            return false;
        }
        File file = (File)obj;
        return this.parent == file.parent && this.name.equalsIgnoreCase(file.name);
    }

    public File copy() {
        return new File(this.name, this.openingApp, this.data.func_74737_b());
    }

    public File copy(String newName) {
        return new File(newName, this.openingApp, this.data.func_74737_b());
    }
}

